/**
*
* Copyright 2013 Radek Henys
* 
* This file is part of Spelling Alphabet Trainer.
*
* Spelling Alphabet Trainer is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Spelling Alphabet Trainer is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Spelling Alphabet Trainer.  If not, see <http://www.gnu.org/licenses/>.
*
*/
package com.mouseviator.spelling.alphabet.trainer;

/**
 * Trida slouzici pro pouziti jako polozka seznamu - nejcasteji tedy pro JList, JComboBox. Umoznuje nastavit popisek -
 * {@link #setTitle(java.lang.String) } (tento titulek vraci tez funkce toString) a data polozky {@link #setItemData(java.lang.Object) } 
 * zadaneho datoveho typu.
 * 
 * @param <DataType> Datovy typ pro datovou cast polozky.
 * @author Murdock
 */
public class ListItem<DataType> {
    private String      title;
    private DataType    itemData;

    /**
     * Vychozi konstruktor pro nastaveni dat polozce.
     * 
     * @param title Popisek, to co se zobrazi v seznamu. 
     * @param itemData Data co si ma polozka pamatovat.
     */
    public ListItem(String title, DataType itemData) {
        this.title = title;
        this.itemData = itemData;
    }
    
    /**
     * @return Vraci popisek polozky.
     */
    public String getTitle() {
        return title;
    }

    /**
     * Metoda pro nastaveni popisu polozky.
     * 
     * @param title Popisek.
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * @return Vraci data co si mela polozka zapamatovat.
     */
    public DataType getItemData() {
        return itemData;
    }

    /**
     * Metoda pro nastaveni dat co chceme aby si polozka pamatovala.
     * 
     * @param itemData Data k zapamatovani.
     */
    public void setItemData(DataType itemData) {
        this.itemData = itemData;
    }
    
    @Override
    public String toString() {
        return title;
    }
    
   @Override
    public boolean equals(Object obj) {
        //pokud jde jen o objekt typu
        if (obj == null)
            return false;
        //Aby se sobe objekty rovnaly, musi jit bud o objekt samotny
        if (this == obj) {
            return true;
        //nebo musi mit vnitrni data stejny typ jako zadany objekt, napriklad se obejkt, ktery ma oItemData integer porovnava primo s cislem, integer
        } else if (obj.getClass() == this.itemData.getClass()) {
            return this.itemData.equals(obj);
        //nebo musi jit o stejnou tridu objektu, pak se porovna nazev i druhotna data
        } else if (obj.getClass() == ListItem.class) {
            ListItem pObj = (ListItem)obj;
            return (this.getTitle().equals(pObj.getTitle()) && this.getItemData().equals(pObj.getItemData()));
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 97 * hash + (this.itemData != null ? this.itemData.hashCode() : 0);
        return hash;
    }    
}
